//=============================================================================
// RPGツクールMZ - EpGauge.js
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc TPゲージを改変してEPゲージを作成します。
 * @author emoriiin979
 *
 * @help EpGauge.js
 *
 * プラグインコマンドはありません。
 */

(() => {
    "use strict";

    const maxTps = [100, 300, 999];

    //-------------------------------------------------------------------------
    // ColorManager

    ColorManager.tpColor = function(actor) {
        if (!actor) {
            return this.normalColor();
        } else if (actor.tp < maxTps[0]) {
            return this.normalColor();
        } else if (actor.tp < maxTps[1]) {
            return "#ff99ff";
        } else if (actor.tp < maxTps[2]) {
            return "#ff00ff";
        } else {
            return "#ff0000";
        }
    };

    //-------------------------------------------------------------------------
    // Game_BattlerBase

    Game_BattlerBase.prototype.maxTp = function() {
        return maxTps[2];
    };

    //-------------------------------------------------------------------------
    // Sprite_Gauge

    Sprite_Gauge.prototype.currentMaxValue = function() {
        if (this._battler) {
            switch (this._statusType) {
                case "hp":
                    return this._battler.mhp;
                case "mp":
                    return this._battler.mmp;
                case "tp":
                    return maxTps[0];
                case "time":
                    return 1;
            }
        }
        return NaN;
    };

    //-------------------------------------------------------------------------
    // TextManager
    //
    // EP上昇時のメッセージを定義します。

    Object.defineProperty(TextManager, "actorRape", {
        value: "%1の性感値が \\c[27]%2\\c[0] 上昇した！",
    });
})();
